# Rule 16.5 A *default* label shall appear as either the first or the last *switch label* of a *switch* statement

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
This rule makes it easy to locate the *default* label within a *switch* statement.

## Example
```c
switch ( x )
{
  default:            /* Compliant - default is the first label */
  case 0:
    ++x;
    break;
  case 1:
  case 2:
    break;
}

switch ( x )
{
  case 0:
    ++x;
    break;
  default:            /* Non-compliant - default is mixed with the case labels */
    x = 0;
    break;
  case 1:
  case 2:
    break;
}

switch ( x )
{
  case 0:
    ++x;
    break;
  case 1:
  case 2:
    break;
  default:            /* Compliant - default is the final label */
    x = 0;
    break;
}
```

## See also
Rule 15.7, Rule 16.1

---

Copyright The MISRA Consortium Limited © [Date - March 2025].