# Rule 17.3 A function shall not be declared implicitly

## Category
Mandatory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
Provided that a function call is made in the presence of a prototype, a *constraint* ensures that the number of arguments matches the number of parameters and that each argument can be assigned to its corresponding parameter.

If a function is declared implicitly, a C90 compiler will assume that the function has a return type of *int*. Since an implicit function declaration does not provide a prototype, a compiler will have no information about the number of function parameters and their types. Inappropriate type conversions may result in passing the arguments and assigning the return value, as well as other undefined behaviour.

For C99 and later, implicit declaration is not permitted - however some implementations still support this as a language extension; such use is therefore also a violation of Dir 1.2.

## Example
If the function `power` is declared as:
```c
extern double power ( double d, int n );
```
but the declaration is not visible in the following code then undefined behaviour will occur.
```c
void func ( void )
{
  /* Non-compliant - return type and both argument types incorrect */
  double sq1 = power ( 1, 2.0 );
}
```

## See also
Dir 1.2, Rule 8.2, Rule 8.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].