# Rule 18.5 Declarations should contain no more than two levels of pointer nesting

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
No more than two *pointer declarators* should be applied consecutively to a type. Any *typedef-name* appearing in a declaration is treated as if it were replaced by the type that it denotes.

## Rationale
The use of more than two levels of pointer nesting can impair the ability to understand the behaviour of the code, and should therefore be avoided.

## Example
```c
typedef int8_t * INTPTR;

void function ( int8_t ** arrPar[ ] )     /* Non-compliant */
{
  int8_t ** obj2;                         /* Compliant     */
  int8_t *** obj3;                        /* Non-compliant */
  INTPTR * obj4;                          /* Compliant     */
  INTPTR * const * const obj5;            /* Non-compliant */
  int8_t ** arr[ 10 ];                    /* Compliant     */
  int8_t ** ( *parr )[ 10 ];              /* Compliant     */
  int8_t * ( **pparr )[ 10 ];             /* Compliant     */
}

struct s
{
  int8_t * s1;                            /* Compliant     */
  int8_t ** s2;                           /* Compliant     */
  int8_t *** s3;                          /* Non-compliant */
};

struct s * ps1;                           /* Compliant     */
struct s ** ps2;                          /* Compliant     */
struct s *** ps3;                         /* Non-compliant */

int8_t ** ( *pfunc1 )( void );            /* Compliant     */
int8_t ** ( **pfunc2 )( void );           /* Compliant     */
int8_t ** ( ***pfunc3 )( void );          /* Non-compliant */
int8_t *** ( **pfunc4 )( void );          /* Non-compliant */
```
*Note:*
*   `arrPar` is of type pointer to pointer to pointer to `int8_t` because parameters declared with array type are converted to a pointer to the initial element of the array — this is three levels and is non-compliant;
*   `arr` is of type array of pointer to pointer to `int8_t` — this is compliant;
*   `parr` is of type pointer to array of pointer to pointer to `int8_t` — this is compliant;
*   `pparr` is of type pointer to pointer to array of pointer to `int8_t` — this is compliant.

---

Copyright The MISRA Consortium Limited © [Date - March 2025].