# Rule 20.6 Tokens that look like a preprocessing directive shall not occur within a macro argument

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
An argument containing sequences of tokens that would otherwise act as preprocessing directives leads to undefined behaviour.

## Example
```c
#include <stdio.h>

#define M( A ) printf ( #A )

void main ( void )
{
  M (
#ifdef SW        /* Non-compliant */
    "Message 1"
#else            /* Non-compliant */
    "Message 2"
#endif           /* Non-compliant */
  );
}
```
The above may print
`#ifdef SW "Message 1" #else "Message 2" #endif`
or
`"Message 2"`
or exhibit some other behaviour.

---

Copyright The MISRA Consortium Limited © [Date - March 2025].