# Rule 23.8 A *default* association shall appear as either the first or the last association of a generic selection

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Amplification
A *default* association shall only appear as either the first generic association in the association list, or the last — this rule only applies when a generic selection contains a *default* association.

## Rationale
Having a *default* association appear as either the first or last in the association list makes it easy to locate, clarifying the intent of the selection structure.

## Example
```c
/* Non-compliant - default is not first or last association */
#define sqrt(X) ( _Generic((X) \
  , float   : sqrtf \
  , default : sqrt \
  , double  : sqrtd) (X) )

/* Compliant - default is first association */
#define cbrt(X) ( _Generic((X) \
  , default : cbrt \
  , float   : cbrtf \
  , double  : cbrtd) (X) ) 

/* Compliant - no default */
#define assert_untyped_nonatomic(X) ( _Generic((X) \
  , void *                : handle_ptr \
  , void const *          : handle_ptr \
  , void volatile *       : handle_ptr \
  , void const volatile * : handle_ptr) (X) ) 
```

## See also
Rule 16.5, Rule 23.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].