# Rule 5.8 Identifiers that define objects or functions with external linkage shall be unique

## Category
Required

## Analysis
Decidable, System

## Applies to
C90, C99, C11

## Amplification
An identifier used as an *external identifier* shall not be used for any other purpose in any name space or translation unit, even if it denotes an object with no linkage.

## Rationale
Enforcing uniqueness of identifier names in this manner helps avoid confusion. Identifiers of objects that have no linkage need not be unique since there is minimal risk of such confusion.

## Example
In the following example, `file1.c` and `file2.c` are both part of the same project:

```c
/* file1.c */
int32_t count;      /* "count" has external linkage */
void foo ( void )   /* "foo"   has external linkage */
{
  int16_t index;    /* "index" has no linkage       */
}

/* file2.c */
static void foo ( void ) /* Non-compliant - "foo" is not unique
{                         * (it is already defined with external
                          * linkage in file1.c) */
  int16_t count;         /* Non-compliant - "count" has no linkage
                          * but clashes with an identifier with
                          * external linkage */
  int32_t index;         /* Compliant     - "index" has no linkage */
}
```

## See also
Rule 5.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].