# Rule 6.2 Single-bit named bit-fields shall not be of a signed type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
For C99 and later, the C Standard states that signed integers have exactly one sign-bit, meaning that a single-bit signed bit-field will have no value-bits. In any representation of integers, a meaningful value cannot be specified if there are zero value-bits.

A single-bit signed bit-field is therefore unlikely to behave in a useful way and its presence is likely to indicate programmer confusion.

Although C90 does not provide so much detail regarding the representation of types, the same considerations apply.

Note: this rule does not apply to unnamed bit-fields as their values cannot be accessed.

---

Copyright The MISRA Consortium Limited © [Date - March 2025].