# Rule 8.3 All declarations of an object or function shall use the same names and type qualifiers

## Category
Required

## Analysis
Decidable, System

## Applies to
C90, C99, C11

## Amplification
Storage class specifiers are not included within the scope of this rule.

## Rationale
Using types and qualifiers consistently across declarations of the same object or function encourages stronger typing.

Specifying parameter names in function prototypes allows the function definition to be checked for interface consistency with its declarations.

## Exception
1.  Compatible versions of the same basic type may be used interchangeably. For example, *int*, *signed* and *signed int* are all equivalent.
2.  The naming requirements of this rule do not apply to unnamed function parameters. This is covered by Rule 8.2.

## Example
```c
extern void f ( signed int a );
       void f (        int a );   /* Compliant     - Exception 1 */

extern void g ( signed int b );
extern void g ( signed int   );   /* Compliant     - Exception 2 */

extern void h ( int * const c );
extern void h ( int *       c );  /* Non-compliant - mis-matched type qualifiers */

extern void j ( int d );
extern void j ( int e );          /* Non-compliant - mis-matched parameter names */
```

Note: all the above are not compliant with Dir 4.6; example `g()` is also not compliant with Rule 8.2.

```c
extern int16_t func ( int16_t num, int16_t den );

/* Non-compliant - parameter names do not match */
int16_t func ( int16_t den, int16_t num )
{
  return num / den;
}
```

In this example the definition of `area` uses a different type name for the parameter `h` from that used in the declaration. This does not comply with the rule even though `width_t` and `height_t` are the same basic type.

```c
typedef uint16_t width_t;
typedef uint16_t height_t;
typedef uint32_t area_t;

extern area_t area ( width_t w, height_t h );

area_t area ( width_t w, width_t h )
{
  return ( area_t ) w * h;
}
```

This rule does not require that a function pointer declaration use the same names as a function declaration. The following example is therefore compliant.

```c
extern void f1 ( int16_t x );
extern void f2 ( int16_t y );

void f ( bool_t b )
{
  void ( *fp1 ) ( int16_t z ) = b ? f1 : f2;
}
```

## See also
Rule 8.2, Rule 8.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].