# Rule 0–1–11 (Required) There shall be no unused parameters (named or unnamed) in non-virtual functions.

## Rationale
Unused function parameters are often due to design changes and can lead to mismatched parameter lists.

## Exception
An unnamed parameter in the definition of a function that is used as a callback does not violate this rule.

## Example
```c
typedef int16_t ( * CallbackFn )( int16_t a, int16_t b );
int16_t Callback_1 ( int16_t a, int16_t b ) // Compliant 
{ 
 return a + b; 
}
int16_t Callback_2 ( int16_t a, int16_t b ) // Non-compliant 
{ 
 return a; 
}
int16_t Callback_3 ( int16_t, int16_t b ) // Compliant by exception 
{ 
 return b; 
}
void Dispatch ( int16_t n, 
 int16_t a, 
 int16_t b, 
 int16_t c, // Non-compliant 
 int16_t ) // Non-compliant if Dispatch not a callback. 
{ 
 CallbackFn pFn;
 switch ( n ) 
 { 
 case 0: pFn = &Callback_1; break; 
 case 1: pFn = &Callback_2; break; 
 default: pFn = &Callback_3; break; 
 } 
 ( *pFn )( a, b ); 
}
```

## See also
Rule 0–1–12

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
