# Rule 0–2–1 (Required) An object shall not be assigned to an overlapping object.

## Amplification
[Undefined 5.17(8)]

## Rationale
Assigning between objects that have an overlap in their physical storage leads to undefined behaviour.

## Example
```c
struct s 
{ 
 int16_t m1 [ 32 ]; 
};
struct t 
{ 
 int32_t m2; 
 struct s m3; 
};
void fn ( ) 
{ 
 union // Breaks Rule 9–5–1 
 { 
 struct s u1; 
 struct t u2; 
 } a;
 a.u2.m3 = a.u1; // Non-compliant 
}
```

## See also
Rule 9–5–1

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
