# Rule 10–2–1 (Advisory) All accessible entity names within a multiple inheritance hierarchy should be unique.

## Rationale
If the names are ambiguous, the compiler should report the name clash and not generate arbitrary or unexpectedly resolved code. However, this ambiguity may not be obvious to a developer.
There is also a specific concern that if the member function is virtual, resolving the ambiguity by explicitly referencing the base class in effect removes the virtual behaviour from the function.

## Exception
For the purposes of this rule, visible function identifiers that form an overload set shall be considered as the same entity.

## Example
```c
class B1 
{ 
public: 
 int32_t count; // Non-compliant
 void foo ( ); // Non-compliant 
};
class B2 
{ 
public: 
 int32_t count; // Non-compliant
 void foo ( ); // Non-compliant 
};
class D : public B1, public B2 
{ 
public: 
 void Bar ( ) 
 { 
 ++count; // Is that B1::count or B2::count? 
 foo ( ); // Is that B1::foo() or B2::foo()? 
 } 
};
```
In the above example, in a member function of D, the use of count or foo is ambiguous and must be disambiguated by B1::count, B2::foo, etc.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
