# Rule 15–0–1 (Document) Exceptions shall only be used for error handling.

## Rationale
The exception handling mechanism can provide an effective and clear means of handling error conditions, particularly where a function needs to return both some desired result together with an indication of success or failure. However, because of its ability to transfer control back up the call tree, it can also lead to code that is difficult to understand. Hence it is required that the mechanism is only used to capture behaviour that is in some sense undesirable, and which is not expected to be seen in normal program execution.

## Example
The try...catch mechanism is an acceptable means of catching error conditions thrown locally or in any called functions.
For example, a file reader may fail in a number of different ways: failure to open the file, unexpected or disallowed data in the file, insufficient data in the file, etc. The requirement to process data up to the point where an error is detected, then to perform some tidy up action (or return some success indicator if no error is found), could be achieved, either using goto (undesirable for the reasons described in Rule 6–6–1) or status flags and repeated nested tests to skip further processing once an error is detected. It is argued that the try...catch mechanism provides a clearer way of separating the expected and exceptional behaviours.
```c
bool ReadFile ( const char *name ) 
{ 
 try 
 { 
 if ( /* open name fails */ ) 
 { 
 throw ( "failed to open file" ); 
 }
 if ( /* unexpected data */ ) 
 { 
 throw ( "unexpected data found in file" ); 
 } 
 return true; 
 }
 catch ( const char *message ) 
 { 
 // tidy up after failure to read 
 return false; 
 } 
}
```
The following:
```c
void fn ( ) 
{ 
 try 
 { 
 if ( x < 10 ) 
 { 
 throw ( 10 ); 
 } 
 // Action "A" 
 }
 catch ( int32_t y ) 
 { 
 // Action "B" 
 } 
}
```
could be used as an expensive and confusing way of implementing
```c
if ( x < 10 ) 
{ 
 // Action "B" 
} 
else 
{ 
 // Action "A" 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
