# Rule 15–1–1 (Required) The assignment-expression of a throw statement shall not itself cause an exception to be thrown.

## Rationale
If an exception is thrown when constructing the exception object, or when evaluating the assignment expression that initializes the exception object, it is that exception that propagates in preference to the one that was about to be thrown. This may be inconsistent with developer expectations.

## Example
```c
class E 
{ 
 public: 
 E ( ){ } // Assume constructor cannot cause an exception 
};
try 
{ 
 if ( ... ) 
 { 
 throw E ( ); // Compliant – no exception thrown 
 } // when constructing the object 
}
// construction of E2 causes an exception to be thrown 
class E2 
{ 
 public: 
 E2 ( ) 
 { 
 throw 10; 
 } 
};
try 
{ 
 if ( ... ) 
 { 
 throw E2 ( ); // Non-compliant – int exception thrown 
 // when constructing the E2 object 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
