# Rule 15–1–3 (Required) An empty throw (throw;) shall only be used in the compound-statement of a catch handler.

## Amplification
[Implementation 15.3(9), 15.5.1(2)]

## Rationale
An empty throw re-throws the temporary object that represents an exception. Its use is intended to enable the handling of an exception to be split across two or more handlers.
However, syntactically, there is nothing to prevent throw; being used outside a catch handler, where there is no exception object to re-throw. This may lead to an implementation-defined program termination.

## Example
```c
void f1 ( void ) 
{ 
 try 
 { 
 throw ( 42 ); 
 }
 catch ( int32_t i ) // int will be handled here first 
 { 
 if ( i > 0 ) 
 { 
 throw; // and then re-thrown - Compliant 
 } 
 } 
}
void g1 ( void ) 
{ 
 try 
 { 
 f1 ( ); 
 }
 catch ( int32_t i ) 
 { 
 // Handle re-throw from f1 ( ) 
 // after f1's handler has done what it needs 
 } 
}
void f2 ( void ) 
{ 
 throw; // Non-compliant 
}
void g2 ( void ) 
{ 
 try 
 { 
 throw; // Non-compliant 
 }
 catch ( ... ) 
 { 
 // ... 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
