# Rule 16–0–2 (Required) Macros shall only be #define’d or #undef’d in the global namespace.

## Rationale
While it is legal to place #define or #undef directives anywhere in a source file, placing them outside of the global namespace is misleading as their scope is not restricted. This may be inconsistent with developer expectations.

## Example
```c
#ifndef MY_HDR 
#define MY_HDR // Compliant
namespace NS 
{ 
 #define FOO // Non-compliant 
 #undef FOO // Non-compliant 
}
#endif
```

## See also
Rule 16–0–3

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
