# Rule 16–0–6 (Required) In the definition of a function-like macro, each instance of a parameter shall be enclosed in parentheses, unless it is used as the operand of # or ##.

## Rationale
If parentheses are not used, then the operator precedence may not give the desired results when the preprocessor substitutes the macro into the code.
Within a definition of a function-like macro, the arguments shall be enclosed in parentheses.

## Example
Define an abs function using:
```c
#define abs(x) (((x) >= 0) ? (x) : -(x)) // Compliant
```
and not:
```c
#define abs(x) ((x >= 0) ? x : -x) // Non-compliant
```
Consider what happens if the second, incorrect, definition is substituted into the expression:
```c
z = abs( a - b );
```
giving:
```c
z = ((a - b >= 0) ? a - b : -a – b);
```
The sub-expression -a - b is equivalent to (-a)-b rather than -(a-b) as intended. Putting all the parameters in parentheses in the macro definition avoids this problem.
```c
#define subs(x) a ## x // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
