# Rule 16–1–1 (Required) The defined preprocessor operator shall only be used in one of the two standard forms.

## Amplification
[Undefined 16.1(4)]

## Rationale
The only two permissible forms for the defined preprocessor operator are:
 defined ( identifier )
 defined identifier
Any other form is a constraint violation, but this is not reported by all compliers.

## Example
```c
#if defined ( X > Y ) // Non-compliant – constraint violation
```
Generation of the token defined during expansion of a #if or #elif preprocessing directive also leads to undefined behaviour and shall be avoided, for example:
```c
#define DEFINED defined 
#if DEFINED(X) // Non-compliant - undefined behaviour
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
