# Rule 17–0–5 (Required) The setjmp macro and the longjmp function shall not be used.

## Category
Required

## Rationale
setjmp and longjmp allow the normal function call mechanisms to be bypassed, and shall not be
used, since exception handling provides a better defined mechanism for this.

## Example
```cpp
#include <setjmp.h>
void f2 ( );
jmp_buf buf;
void f1 ( ) 
{ 
 if ( !setjmp ( buf ) ) // Non-compliant 
 { 
 f2 ( ); 
 } 
 else 
 { 
 } 
}
void f2 ( ) 
{ 
 longjmp ( buf, 10 ); // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
