# Rule 18–4–1 (Required) Dynamic heap memory allocation shall not be used.

## Category
Required

## Rationale
The use of dynamic memory can lead to out-of-storage run-time failures, which are undesirable.
The built-in new and delete operators, other than the placement versions, use dynamic heap
memory. The functions calloc, malloc, realloc and free also use dynamic heap memory.
There is a range of unspecified, undefined and implementation-defined behaviour associated with
dynamic memory allocation, as well as a number of other potential pitfalls. Dynamic heap memory
allocation may lead to memory leaks, data inconsistency, memory exhaustion, non-deterministic
behaviour, etc.
Note that some implementations may use dynamic heap memory allocation to implement other
functions (for example, functions in the library cstring). If this is the case, then these functions
shall also be avoided.

## Example
```cpp
void f1 ( ) 
{ 
 int32_t * i = new int32_t; // Non-compliant
 delete i; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
