# Rule 4–10–1 (Required) NULL shall not be used as an integer value.

## Rationale
In C++, the literal 0 is both an integer type and the null-pointer-constant. To meet developer expectations, NULL should be used as the null-pointer-constant, and 0 for the integer zero.
Note: as a result of this rule, NULL is considered to have pointer type.

## Example
```c
#include <cstddef>
void f1 ( int32_t ); 
void f2 ( int32_t * );
void f3 ( ) 
{ 
 f1 ( NULL ); // Not-compliant, NULL used as an integer 
 f2 ( NULL ); // Compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
