# Rule 4–5–2 (Required) Expressions with type enum shall not be used as operands to built-in operators other than the subscript operator [ ], the assignment operator =, the equality operators == and !=, the unary & operator, and the relational operators <, <=, >, >=.

## Rationale
Enumerations have implementation-defined representation and so should not be used in arithmetic contexts.

## Example
```c
enum { COLOUR_0, COLOUR_1, COLOUR_2, COLOUR_COUNT } colour;
if ( COLOUR_0 == colour ) // Compliant 
if ( ( COLOUR_0 + COLOUR_1 ) == colour ) // Non-compliant 
if ( colour < COLOUR_COUNT ) // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
