# Rule 6–2–3 (Required) Before preprocessing, a null statement shall only occur on a line by itself; it may be followed by a comment, provided that the first character following the null statement is a white‑space character.

## Rationale
Null statements should not normally be included deliberately, but where they are used, they shall appear on a line by themselves. White‑space characters may precede the null statement to preserve indentation. If a comment follows the null statement, then at least one white‑space character shall separate the null statement from the comment. The use of a white‑space character to separate the null statement from any following comment is required on the grounds that it provides an important visual cue to reviewers. Following this rule enables a static checking tool to warn of null statements appearing on a line with other text, which would normally indicate a programming error.

## Example
```c
while ( ( port & 0x80 ) == 0 ) 
{ 
 ; // wait for pin - Compliant 
 /* wait for pin */ ; // Non-compliant, comment before ; 
 ;// wait for pin – Non-compliant, no white-space char after ; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
