# Rule 7–2–1 (Required) An expression with enum underlying type shall only have values corresponding to the enumerators of the enumeration.

## Amplification
[Unspecified 7.2(9)]

## Rationale
It is unspecified behaviour if the evaluation of an expression with enum underlying type yields a value which does not correspond to one of the enumerators of the enumeration.
Additionally, other rules in this standard assume that objects of enum type only contain values corresponding to the enumerators. This rule ensures the validity of these assumptions.
One way of ensuring compliance when converting to an enumeration is to use a switch statement.

## Example
```c
enum1 convert ( int16_t v ) 
{ 
 enum1 result = enum1_ERROR;
 switch ( v ) 
 { 
 case 0: { result = enum1_E1; break; } 
 case 1: { result = enum1_E2; break; } 
 default: { throw ( ENUM_ERROR ); break; } 
 } 
 return result; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
