# Rule 7–3–6 (Required) using-directives and using-declarations (excluding class scope or function scope using-declarations) shall not be used in header files.

## Rationale
It is important to ensure that the order of inclusion of header files cannot affect the behaviour of a program.

## Example
```c
// f1.h 
void foo ( char_t a );
namespace NS1 
{ 
 void foo( int32_t a ); 
}
inline void bar ( ) 
{ 
 foo ( 0 ); 
}
// f2.h 
namespace NS1 
{ 
}
using namespace NS1;
// f1.cc 
#include "f1.h" 
#include "f2.h"
int32_t m1 ( ) 
{ 
 bar ( ); // bar calls foo ( char_t ); 
}
// f2.cc 
#include "f2.h" 
#include "f1.h"
void m2 ( ) 
{ 
 bar ( ); // bar calls foo ( int32_t ); 
}
```
In the above example, changing the order of the header files alters the meaning of the program.

## See also
ISO/IEC 14882:2003 [1] §7.3.3, §7.3.4

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
