# Rule 9–5–1 (Required) Unions shall not be used.

## Amplification
[Implementation 3.9(4, 5)]

## Rationale
The use of unions to access an object in different ways may result in the data being misinterpreted. Therefore, this rule prohibits the use of unions for any purpose.
It is recognized nonetheless that there are situations in which the careful use of unions is desirable in constructing an efficient implementation. In such situations, deviations to this rule are considered acceptable provided that all relevant implementation‑defined behaviour is documented. This might be achieved in practice by referencing the implementation section of the compiler manuals from the design documentation.

## Example
```c
namespace NS1 
{ 
 // Compliant - no union 
}
namespace NS2 
{ 
 union U1 // Non-compliant – union 
 { 
 int32_t i; 
 float32_t j; 
 }; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
