# Rule 12.2.3 A named bit-field with signed integer type shall not have a length of one bit

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
A single-bit signed bit-field is unlikely to behave in a useful way and its presence is likely to indicate an
error.

*Note:* anonymous signed bit-fields of any length are allowed as they cannot be accessed.

## Example
```cpp
struct S
{
 signed int a : 1; // Non-compliant
 signed int : 1; // Rule does not apply
 signed int : 0; // Rule does not apply
 signed int b : 2; // Compliant
 int c : 1; // Non-compliant
};
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
