# Rule 13.3.3 The parameters in all declarations or overrides of a function shall either be unnamed or have identical names

## Category
Required

## Analysis
Decidable, System

## Rationale
The name given to a parameter helps document the purpose of the parameter. If a function parameter
is renamed in a subsequent *declaration*, then having different names for the same object may lead to
developer confusion.

## Example
The following example is compliant:

```cpp
void fn1( int32_t a );
void fn1( int32_t );
```

The following example is non-compliant as the parameter names have been swapped:

```cpp
void CreateRectangle( uint32_t Height, uint32_t Width );
void CreateRectangle( uint32_t Width, uint32_t Height );
```

The following example is non-compliant as the named parameters are different:

```cpp
void fn2( int32_t a );
void fn2( int32_t b ) { }
```

The following example is non-compliant as the parameter name in the override differs from the
parameter name in the overridden function:

```cpp
class Shape
{
 virtual void draw( Canvas & destination ) = 0;
};

class Rectangle : public Shape
{
 void draw( Canvas & canvas ) override;
};
```

The rule does not apply to the following example as the specialization is a different *declaration* (note
that this example is non-compliant with Rule 17.8.1):

```cpp
template< class T > void f( T t );
template<> void f< int32_t >( int32_t i );
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
