# Rule 19.2.2 The #include directive shall be followed by either a <filename> or "filename" sequence

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies after macro replacement has been performed.

## Rationale
*Undefined behaviour* occurs if a `#include` directive does not use one of the following forms:

```cpp
#include <filename>
#include "filename"
```

## Example
```cpp
#include <filename.h> // Compliant
#include "filename.h" // Compliant
#include "./include/cpu.h" // Compliant - filename may include a path
#include another.h // Non-compliant

#define HEADER "filename.h"
#include HEADER // Compliant

#define FILENAME file2.h
#include FILENAME // Non-compliant

#define BASE "base"
#define EXT ".ext"
#include BASE EXT // Non-compliant - expands to an invalid form
 // #include "base" ".ext"
// - string concatenation occurs after preprocessing
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
