# Rule 5.13.5 The lowercase form of `L` shall not be used as the first character in a literal suffix

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule does not apply to *user-defined-literals*.

## Rationale
Using the uppercase suffix `L` removes the potential ambiguity between `1` (digit 1) and `l` (lowercase `L`)
when declaring numeric literals. The ambiguity only occurs when lowercase `L` is used as the first letter
of a suffix.

## Example
```cpp
int64_t const a = 0L; // Compliant
int64_t const b = 0l; // Non-compliant
uint64_t const c = 1Lu; // Compliant
uint64_t const d = 1lU; // Non-compliant
uint64_t const e = 2uLL; // Compliant
uint64_t const f = 2Ull; // Compliant
long long const g = 3LL; // Compliant
long long const h = 3ll; // Non-compliant
long double const i = 1.2L; // Compliant
long double const j = 3.4l; // Non-compliant

constexpr Litre operator"" _l( long double val ) noexcept
{
  return Litre { val }; // Assumes type Litre is defined
}

auto volume = 42.1_l; // Rule does not apply
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
