# Rule 6.9.1 The same type aliases shall be used in all *declarations* of the same *entity*

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
If a redeclaration uses different type aliases to those in its previous *declarations*, it may not be clear
that the *declarations* refer to the same *entity*.

## Example
```cpp
typedef int32_t INT;
using Index = int32_t;

       INT     i;
extern int32_t i; // Non-compliant

       INT j;
extern INT j; // Compliant
```
In the following, there are two *declarations* of `g`, even though the types differ due to the top level `const`
qualifier:
```cpp
void g( int32_t i );
void g( Index const i ); // Non-compliant - int32_t vs. Index

void h( Index i );
void h( Index const index ); // Compliant - Index used consistently

void h( int32_t * i ); // Rule does not apply - different overload
```

## See also
Rule 6.2.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
