# Rule 7.11.1 `nullptr` shall be the only form of the *null-pointer-constant*

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
Using any integral literal representing zero, including the literal `0` or the macro `NULL`, to represent the
*null-pointer-constant* is a violation of this rule.

In addition, the macro `NULL` shall not be used in any other context.

## Rationale
The C++ Standard defines the object `nullptr` as the *null-pointer-constant*.

The literal `0` can also be used to represent a *null-pointer-constant*. However, `0` has type `int`, and its use
can lead to unexpected overload resolution. Note that the macro `NULL` expands to `0`.

Note: some library functions provide overloads for `std::nullptr_t` so that they can be selected
during overload resolution at compile-time, avoiding the need for a run-time check against `nullptr`.

## Example
```cpp
void f1( int32_t * );

void f2()
{
  f1( nullptr ); // Compliant
  f1( 0 ); // Non-compliant - 0 used as the null pointer constant
}

// The following example shows the selection of an integer overload when NULL (which has a value of 0)
// is used instead of nullptr:

void f3( int32_t );
void f3( int32_t * );

void f4()
{
  f3( NULL ); // Non-compliant - calls the int32_t overload
  f3( nullptr ); // Compliant - calls the int32_t * overload
}

// The following example shows non-compliant uses of NULL, where it is not used as the null-pointer-
// constant:

#define MYNULL NULL // Non-compliant

void f5()
{
  int32_t one = NULL + 1; // Non-compliant - NULL used as an integer

  throw NULL; // Non-compliant - caught by catch ( int )
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
