# Dir 0.3.1 Floating-point arithmetic should be used appropriately

## Category
Advisory

## Amplification
A tool should highlight all suspicious uses of floating-point arithmetic.

## Rationale
The safe use of floating-point arithmetic requires a high level of numerical analysis skills and in-depth
knowledge of the compiler and target hardware.

The incorrect use of floating-point may lead to problems related to the presence of positive and
negative zero, loss of precision, NaNs (quiet and signalling), infinities, overflow, underflow, catastrophic
cancellation, etc.

## Example
```cpp
bool myIsNaN( double d )
{
  return d == std::numeric_limits< double >::quiet_NaN(); // Always returns false
}

void f()
{
  float f1 = 1E38f;
  float f2 = 10.0f;
  float f3 = 0.1f;
  float f4 = ( f1 * f2 ) * f3;
  float f5 = f1 * ( f2 * f3 ); // Values in f4 and f5 are significantly different
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
