# Rule 17.1 The features of `<stdarg.h>` shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
None of *va_list*, *va_arg*, *va_start*, *va_end* and, for C99, *va_copy* shall be used.

## Rationale
The Standard lists many instances of undefined behaviour associated with the features of
`<stdarg.h>`, including:
* *va_end* not being used prior to end of a function in which *va_start* was used;
* *va_arg* being used in different functions on the same *va_list*;
* The type of an argument not being compatible with the type specified to *va_arg*.

## Example
```c
#include <stdarg.h>
void h ( va_list ap ) /* Non-compliant */
{
 double y;
 y = va_arg ( ap, double ); /* Non-compliant */
}
void f ( uint16_t n, ... )
{
 uint32_t x;
 va_list ap; /* Non-compliant */
 va_start ( ap, n ); /* Non-compliant */
 x = va_arg ( ap, uint32_t ); /* Non-compliant */
 h ( ap );
 /* undefined - ap is indeterminate because va_arg used in h ( ) */
 x = va_arg ( ap, uint32_t ); /* Non-compliant */
 /* undefined - returns without using va_end ( ) */
}
void g ( void )
{
 /* undefined - uint32_t:double type mismatch when f uses va_arg ( ) */
 f ( 1, 2.0, 3.0 );
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
