# Rule 20.9 All identifiers used in the controlling expression of `#if` or `#elif` preprocessing directives shall be `#define`'d before evaluation

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
As well as using a `#define` preprocessor directive, identifiers may effectively be `#define`'d in other,
implementation-defined, ways. For example some implementations support:
* Using a compiler command-line option, such as `-D` to allow identifiers to be defined prior to
translation;
* Using environment variables to achieve the same effect;
* Pre-defined identifiers provided by the compiler.

## Rationale
If an attempt is made to use a macro identifier in a preprocessor directive, and that identifier has
not been defined, then the preprocessor will assume that it has a value of zero. This may not meet
developer expectations.

## Example
The following examples assume that the macro `M` is undefined.
```c
#if M == 0 /* Non-compliant */
 /* Does 'M' expand to zero or is it undefined? */
#endif
#if defined ( M ) /* Compliant - M is not evaluated */
#if M == 0 /* Compliant - M is known to be defined */
 /* 'M' must expand to zero. */
#endif
#endif
/* Compliant - B is only evaluated in ( B == 0 ) if it is defined */
#if defined ( B ) && ( B == 0 )
#endif
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
