# Rule 8.13 A pointer should point to a const-qualified type whenever possible

## Category
Advisory

## Analysis
Undecidable, System

## Applies to
C90, C99

## Amplification
A pointer should point to a *const*-qualified type unless either:
* It is used to modify an object, or
* It is copied to another pointer that points to a type that is not *const*-qualified by means of either:
  - Assignment, or
  - Memory move or copying functions.

For the purposes of simplicity, this rule is written in terms of pointers and the types that they point to. However, it applies equally to arrays and the types of the elements that they contain. An array should have elements with *const*-qualified type unless either:
* Any element of the array is modified, or
* It is copied to a pointer that points to a type that is not *const*-qualified by the means described above.

## Rationale
This rule encourages best practice by ensuring that pointers are not inadvertently used to modify objects. Conceptually, it is equivalent to initially declaring:
* All arrays to have elements with *const*-qualified type, and
* All pointers to point to *const*-qualified types.

and then removing *const*-qualification only where it is necessary to comply with the *constraints* of the language standard.

## Example
In the following non-compliant example, `p` is not used to modify an object but the type to which it points is not *const*-qualified.

```c
uint16_t f ( uint16_t *p )
{
  return *p;
}
```

The code would be compliant if the function were defined with:

```c
uint16_t g ( const uint16_t *p )
```

The following example violates a *constraint* because an attempt is made to use a *const*-qualified pointer to modify an object.

```c
void h ( const uint16_t *p )
{
  *p = 0;
}
```

In the following example, the pointer `s` is *const*-qualified but the type it points to is not. Since `s` is not used to modify an object, this is non-compliant.

```c
#include <string.h>

char last_char ( char * const s )
{
  return s[ strlen ( s ) - 1u ];
}
```

The code would be compliant if the function were defined with:

```c
char last_char ( const char * const s )
```

In this non-compliant example, none of the elements of the array `a` are modified but the element type is not *const*-qualified.

```c
uint16_t first ( uint16_t a[ 5 ] )
{
  return a[ 0 ];
}
```

The code would be compliant if the function were defined with:

```c
uint16_t first ( const uint16_t a[ 5 ] )
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
