# Rule 8.2 Function types shall be in prototype form with named parameters

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
The early version of C, commonly referred to as K&R C [30], did not provide a mechanism for checking the number of arguments or their types against the corresponding parameters. The type of an object or function did not have to be declared in K&R C since the default type of an object and the default return type of a function was *int*.

The C90 standard introduced function prototypes, a form of function declarator in which the parameter types were declared. This permitted argument types to be checked against parameter types. It also allowed the number of arguments to be checked except when a function prototype specified that a variable number of arguments was expected. The C90 standard did not require the use of function prototypes for reasons of backward compatibility with existing code. For the same reason, it continued to permit types to be omitted in which case the type would default to *int*.

The C99 standard removed the default *int* type from the language but continued to allow K&R-style function types in which there was no means to supply parameter type information in a declaration and it was optional to supply parameter type information in a definition.

The mismatch between the number of arguments and parameters, their types and the expected and actual return type of a function provides potential for undefined behaviour. The purpose of this rule along with Rule 8.1 and Rule 8.4 is to avoid this undefined behaviour by requiring parameter types and function return types to be specified explicitly. Rule 17.3 ensures that this information is available at the time of a function call, thereby requiring the compiler to diagnose any mismatch that is detected.

This rule also requires that names be specified for all the parameters in a declaration. The parameter names can provide useful information regarding the function interface and a mismatch between a declaration and definition might be indicative of a programming error.

Note: An empty parameter list is not valid in a prototype. If a function type has no parameters its *prototype form* uses the keyword *void*.

## Example
The first example shows declarations of some functions and the corresponding definitions for some of those functions.

```c
/* Compliant */
extern int16_t func1 ( int16_t n );

/* Non-compliant - parameter name not specified */
extern void func2 ( int16_t );

/* Non-compliant - not in prototype form */
static int16_t func3 ( );

/* Compliant - prototype specifies 0 parameters */
static int16_t func4 ( void );

/* Compliant */
int16_t func1 ( int16_t n )
{
  return n;
}

/* Non-compliant - old style identifier and declaration list */
static int16_t func3 ( vec, n )
  int16_t *vec;
  int16_t n;
{
  return vec[ n - 1 ];
}
```

This example section shows the application of the rule to function types other than in function declarations and definitions.

```c
/* Non-compliant - no prototype */
int16_t ( *pf1 ) ( );

/* Compliant - prototype specifies 0 parameters */
int16_t ( *pf1 ) ( void );

/* Non-compliant - parameter name not specified */
typedef int16_t ( *pf2_t ) ( int16_t );

/* Compliant */
typedef int16_t ( *pf3_t ) ( int16_t n );
```

## See also
Rule 8.1, Rule 8.4, Rule 17.3

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
