# Rule 8.5 An external object or function shall be declared once in one and only one file

## Category
Required

## Analysis
Decidable, System

## Applies to
C90, C99

## Amplification
This rule applies to non-defining declarations only.

## Rationale
Typically, a single declaration will be made in a *header file* that will be included in any translation unit in which the identifier is defined or used. This ensures consistency between:
* The declaration and the definition;
* Declarations in different translation units.

Note: there may be many *header files* in a project, but each external object or function shall only be declared in one *header file*.

## Example
```c
/* featureX.h */
extern int16_t a;   /* Declare a */

/* file.c */
#include "featureX.h"

int16_t a = 0;      /* Define a */
```

## See also
Rule 8.4

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
