# Rule 21.23 All operand arguments to any multi-argument type-generic macros declared in <tgmath.h> shall have the same standard type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C99, C11
## Amplification
This rule applies to the following multi-argument type-generic macros:
`atan2`, `copysign`, `fdim`, `fma`, `fmax`, `fmin`, `fmod`, `frexp`, `hypot`, `ldexp`, `nextafter`, `nexttoward`, `pow`, `remainder`, `remquo`, `scalbn`, `scalbln`
All operand arguments passed to any of the multi-argument macros defined in `<tgmath.h>` shall have the same *standard type*, after integer promotion has been applied to any integer arguments.
Note: The final parameter to the *frexp* and *remquo* macros is for output, and is not considered an operand.
## Rationale
Ensuring that the types used to determine the *corresponding real type* for the whole call expression are consistent makes the relationship between the input values and the result clearer.
On platforms with extended real types, the *essentially real floating* types may not be able to be strictly ordered by precision. In this case there is a risk that if two arguments have different types, the deduced common real type may be an unexpected size or silently lose precision.
## Example
```c
void f (void) {
 float32_t f1;
 float32_t f2;
 float64_t d1;
 float64_t d2;

 f2 = pow(f1, f2); /* Compliant */
 d2 = pow(d1, d2); /* Compliant */
 f2 = pow(f1, d2); /* Non-compliant - unclear which argument was 
 intended to control precision */
 f2 = pow(f1, (float32_t)d2); /* Compliant */
}

void g (void) {
 short s16;
 int i32;
 long l32;
 
 i32 = pow( s16, i32 ); /* Compliant - both arguments are int after
 integer promotion */
 i32 - pow( i32, l32 ); /* Non-compliant - arguments are not the same 
 type after promotion */
 
 i32 = pow( s16, 10 ); /* Compliant - 10 has literal type int */
 i32 = pow( 10u, 110ul ); /* Non-compliant - literal types unsigned int
 and unsigned long */
}
```
## See also
Rule 21.11, Rule 21.22

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
