# Rule 22.10 The value of errno shall only be tested when the last function to be called was an errno-setting-function

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
An *errno-setting-function* is one of those described in Rule 22.8.

## Rationale
The *errno-setting-functions* are the only functions which are required to set `errno` when an error is
detected. Other functions, including those defined in the Standard Library that are not *errno-setting-functions*, may or may not set `errno` to indicate that an error has occurred. The use of `errno` to
detect errors within these functions will fail for an implementation that does not set `errno` as it will
be left unmodified.

Given that a zero value for `errno` does not therefore guarantee the absence of an error within a
function that is not an *errno-setting-function*, its value shall not be tested as the outcome must be
considered unreliable.

## Example
In the following example:
*   `atof` may or may not set `errno` when an error is detected;
*   `strtod` is an *errno-setting-function*.

```c
void f ( void )
{
 float64_t f64;

 errno = 0;

 f64 = atof ( "A.12" );

 if ( 0 == errno ) /* Non-compliant */
 {
 /* f64 may not have a valid value in here. */
 }

 errno = 0;

 f64 = strtod ( "A.12", NULL );

 if ( 0 == errno ) /* Compliant */
 {
 /* f64 will have a valid value in here. */
 }
}
```

## See also
Rule 22.8, Rule 22.9

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
