# Rule 22.14 Thread synchronization objects shall be initialized before being accessed

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C11

## Amplification
Before being accessed, mutex objects shall be initialized by calling *mtx_init()*, and condition variables
by calling *cnd_init()*.

The second parameter of *mtx_init()* shall be either *mtx_plain*, *mtx_timed*, (*mtx_plain* | *mtx_recursive*),
or (*mtx_timed* | *mtx_recursive*).

## Rationale
Mutex objects have to be explicitly created by calling function *mtx_init()*, and condition variables have
to be explicitly created by calling function *cnd_init()*.

Invoking *mtx_init()* with a different value of its type parameter than listed above is undefined
behaviour.

Initializing all synchronization objects before creating the threads accessing them is a deterministic
way to prevent threads from accessing synchronization objects with indeterminate state.

## Example
```c
mtx_t Ra;
mtx_t Rb;
mtx_t Rc;

int32_t t1( void *ignore ) /* Thread T1 entry */
{
 mtx_init( &Rb, mtx_plain ); /* Non-compliant - T2 may have already accessed Rb */
 ...
 /* Subsequently locks/unlocks Ra, Rb, Rc */
}

int32_t t2( void *ignore )
{
 /* locks/unlocks Ra, Rb, Rc */
}

thrd_t id1, id2;

void main(void)
{
 mtx_init ( &Ra, mtx_plain ); /* Compliant */

 thrd_create( &id1, t1, NULL );
 thrd_create( &id2, t2, NULL );

 mtx_init ( &Rc, mtx_plain ); /* Non-compliant - T1/T2 may have already
 accessed Rc */

 thrd_join ( id1, NULL );
 thrd_join ( id2, NULL );

 mtx_destroy( &Ra );
 mtx_destroy( &Rb );
 mtx_destroy( &Rc );
}
```

## See also
Dir 4.7

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
