# Rule 22.19 A condition variable shall be associated with at most one mutex object

## Category
Required

## Analysis
Undecidable, System

## Applies to
C11

## Rationale
If the same condition variable is used with different mutex objects by two threads, it is undefined
which mutex will be unlocked upon signalling the condition variable.

## Example
```c
mtx_t Ra;
mtx_t Rb;
cnd_t Cnd;

int32_t t1(void *ignore )
{
 mtx_lock ( &Ra );
 cnd_wait ( &Cnd, &Ra ); /* Non-compliant - t2 uses Cnd with Rb */
 mtx_unlock( &Ra );
 return 0;
}

int32_t t2(void *ignore )
{
 mtx_lock ( &Rb );
 cnd_wait ( &Cnd, &Rb ); /* Non-compliant - t1 uses Cnd with Ra */
 mtx_unlock( &Rb );
 return 0;
}

int32_t t3(void* ignore)
{
 cnd_signal( &Cnd ); /* Unblocks one of Ra and Rb...
 ... unclear whether t1 or t2 resumes */
 return 0;
}
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
