# Rule 8.10 An inline function shall be declared with the static storage class

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C99, C11

## Rationale

If an inline function is declared with external linkage but not defined in the same translation unit, the behaviour is undefined.

A call to an inline function declared with external linkage may call the external definition of the function, or it may use the inline definition. Although this should not affect the behaviour of the called function, it might affect execution timing and therefore have an impact on a real-time program.

Note: an inline function can be made available to several translation units by placing its definition in a header file. 

## See also

Rule 5.9

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
