# Rule 11.4 A conversion shall not be performed between a pointer to object and an arithmetic type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
Conversion of an integer into a pointer to object may result in a pointer that is not correctly aligned, resulting in undefined behaviour.

Conversion of a pointer to object into an integer may produce a value that cannot be represented in the chosen integer type resulting in undefined behaviour.

Casting between a pointer and an integer type should be avoided where possible, but may be necessary when addressing memory mapped registers or other hardware specific features. If casting between integers and pointers is used, care should be taken to ensure that any pointers produced do not give rise to the undefined behaviour discussed under Rule 11.3.

Conversion of an *essentially Boolean*, *essentially character* or *essentially enum* type into a pointer to object may result in a pointer that is not correctly aligned, resulting in undefined behaviour.

Conversion of a pointer to object into an *essentially Boolean*, *essentially character* or *essentially enum* type may produce a value that cannot be represented in the chosen integer type resulting in undefined behaviour.

Conversion of a pointer to object into or from an *essentially floating* type results in undefined behaviour.

## Exception
1.  A *null pointer constant* that has integer type may be converted into a pointer to object;
2.  A conversion between a pointer to an object and an object of type *intptr_t* or *uintptr_t* is allowed, provided that the representation of the object pointer type is identical to the representation of *void \** on that platform.

## Example
```c
uint8_t  *PORTA = ( uint8_t * ) 0x0002; /* Non-compliant */

uint16_t *p;

int32_t  addr = ( int32_t ) &p;         /* Non-compliant */
uint8_t *q    = ( uint8_t * ) addr;     /* Non-compliant */
bool_t   b    = ( bool_t ) p;           /* Non-compliant */

enum etag { A, B } e = ( enum etag ) p; /* Non-compliant */

int16_t *p;
float    f;

f = ( float     ) p;                    /* Non-compliant */
p = ( int16_t * ) f;                    /* Non-compliant */
```

Provided that the representation of the object pointer type is identical to the representation of *void \** on the platform:

```c
extern int16_t * ptr;
uintptr_t uip1 = (uintptr_t)ptr;        /* Conditionally compliant by exception 2 */
```

A conversion between a pointer to an object and an object of type *intptr_t* or *uintptr_t* may be portably accomplished by first converting the pointer to an object to a pointer to *void* and vice versa. See Rule 11.6.

```c
uintptr_t uip2 = (uintptr_t)(void *)ptr; /* Rule does not apply */
```

## See also
Rule 11.3, Rule 11.6, Rule 11.9

---

Copyright The MISRA Consortium Limited © [Date - March 2025].