# Rule 11.6 A cast shall not be performed between pointer to void and an arithmetic type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
Conversion of an integer into a pointer to *void* results in behaviour that is implementation-defined.

Conversion of a pointer to *void* into an integer may produce a value that cannot be represented in the chosen integer type resulting in undefined behaviour.

Conversion between any non-integer arithmetic type and pointer to *void* is undefined.

The C Standard guarantees that any valid pointer to *void* may be converted to an object of type *intptr_t* or *uintptr_t*, and any object of type *intptr_t* or *uintptr_t* may be converted to a pointer to *void*.

## Exception
1.  An *integer constant expression* with value 0 may be cast into pointer to *void*;
2.  A conversion between a pointer to *void* and an object of type *intptr_t* or *uintptr_t* is allowed.

## Example
```c
void     *p;
uint32_t  u;

p = ( void * ) 0x1234u;         /* Non-compliant - implementation-defined */
p = ( void * ) 1024.0f;         /* Non-compliant - undefined-behavior     */
u = ( uint32_t ) p;             /* Non-compliant - implementation-defined */

extern void * ptr;
uintptr_t uip = (uintptr_t)ptr; /* Compliant by exception 2 */
p = (void*)uip;                 /* Compliant by exception 2 */
                                /* Note: p == ptr at this point */
```

## See also
Rule 11.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].