# Rule 12.6 Structure and union members of atomic objects shall not be directly accessed

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Amplification
The C Standard defines the following access functions for atomic objects: *atomic_init()*, *atomic_store()*, *atomic_load()*, *atomic_exchange()*, *atomic_compare_exchange()*.

Accesses to atomic objects of structure and union types shall only be made to the object as a whole, and only using these functions and the assignment operator `=`. In particular, the `.` and `->` operators shall not be used on atomic objects of structure and union type.

## Rationale
The C Standard guarantees absence of data races when performing atomic operations on data shared between threads without requiring explicit protection via mutex or condition variables. The operations have to be performed by dedicated access functions which provide an appropriate built-in protection. Direct access to structure or union members of atomic objects circumvents this protection, thus making them vulnerable to data races.

Note: The *atomic_init()* functions does not avoid data races. Concurrent access to the variable being initialized, even via an atomic operation, constitutes a data race.

## Example
```c
typedef struct s {
  uint8_t a;
  uint8_t b;
} s_t;

_Atomic s_t astr;

sint32_t main(void) 
{
  s_t lstr = { 7U, 42U };
  
  astr.b = 43U;                 /* Non-compliant */

  lstr = atomic_load( &astr );
  lstr.b = 43U;
  atomic_store( &astr, lstr );  /* Compliant */

  lstr.a = 8U;
  astr = lstr;                  /* Compliant */
}
```

## See also
Dir 5.1, Rule 11.4, Rule 9.7

---

Copyright The MISRA Consortium Limited © [Date - March 2025].