# Rule 15.5 A function should have a single point of exit at the end

## Category
Disapplied

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
A function should have no more than one *return* statement.

When a *return* statement is used, it should be the final statement in the compound statement that forms the body of the function.

## Rationale
Functional safety standards, such as IEC 61508 [31] or ISO 26262 [29], encourage the use of the “single-entry single-exit” principle as part of the “modular approach”.

Unstructured languages, such as assembly, allow jumps between arbitrary points in a program, violating this principle.

The C language, with its concept of functions and the corresponding calling mechanism, enforces the “single-entry single-exit” principle through its language definition — for example, multiple return statements within a function all return to the same call site.

If a function has exit points interspersed with statements that produce *persistent side effects*, it is not easy to determine which *side effects* will occur when the function is executed.

## Example
In the following non-compliant code example, early returns are used to validate the function parameters.
```c
bool_t f ( uint16_t n, char *p )
{
  if ( n > MAX    ) { return false; }
  if ( p == NULL ) { return false; }

  return true;
}
```
Use of *goto* may avoid the need for an early return:
```c
bool_t g ( uint16_t n )
{
  bool_t status;

  if ( n > MAX    ) { status = false; goto finish; /* Note: violates Rule 15.1 */ }
  ...
  status = true;

finish:
  return status;
}
```

## See also
Rule 17.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].