# Rule 20.13 A line whose first token is *#* shall be a valid preprocessing directive

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
White-space is permitted between the *#* and preprocessing tokens.

## Rationale
A preprocessor directive may be used to conditionally exclude source code until a corresponding *#else*, *#elif* or *#endif* directive is encountered. A malformed or invalid preprocessing directive contained within the excluded source code may not be detected by the compiler, possibly leading to the exclusion of more code than was intended.

Requiring all preprocessor directives to be syntactically valid, even when they occur within an excluded block of code, ensures that this cannot happen.

## Example
In the following example all the code between the *#ifndef* and *#endif* directives may be excluded if `AAA` is defined. The developer intended that `AAA` be assigned to `x`, but the *#else* directive was entered incorrectly and not diagnosed by the compiler:
```c
#define AAA 2

int32_t foo ( void )
{
  int32_t x = 0;

#ifndef AAA
  x = 1;
#else1        /* Non-compliant */
  x = AAA;
#endif

  return x;
}
```
The following example is compliant because the text `#start` appearing in a comment is not a token:
```c
/*
#start is not a token in a comment 
 */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].