# Rule 22.5 A pointer to a FILE object shall not be dereferenced

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
A pointer to a FILE object shall not be dereferenced directly or indirectly (e.g. by a call to *memcpy* or *memcmp*).

## Rationale
Within the section on “files”, the C Standard states that the address of a FILE object used to control a stream may be significant and a copy of the object may not give the same behaviour. This rule ensures that such a copy cannot be made.

The direct manipulation of a FILE object is prohibited as this may be incompatible with its use as a stream designator.

## Example
```c
#include <stdio.h>

FILE *pf1;
FILE *pf2;
FILE f3;

pf2 = pf1;   /* Compliant     */
f3 = *pf2;   /* Non-compliant */
```
The following example assumes that `FILE *` specifies a complete type with a member named `pos`:
```c
pf1->pos = 0; /* Non-compliant */
```

## See also
Rule 21.6

---

Copyright The MISRA Consortium Limited © [Date - March 2025].