# Rule 8.1 Types shall be explicitly specified

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90

## Rationale
The C90 standard permits types to be omitted in some circumstances, in which case the *int* type is implicitly specified. Examples of the circumstances in which an implicit *int* might be used are:
*   Object declarations;
*   Parameter declarations;
*   Member declarations;
*   *typedef* declarations;
*   Function return types.

The omission of an explicit type might lead to confusion. For example, in the declaration:

`extern void g ( char c, const k );`

the type of `k` is *const int* whereas *const char* might have been expected.

## Example
The following examples show compliant and non-compliant object declarations:

```c
extern          x;  /* Non-compliant - implicit int type */
extern int16_t  x;  /* Compliant     - explicit type     */
const           y;  /* Non-compliant - implicit int type */
const int16_t   y;  /* Compliant     - explicit type     */
```

The following examples show compliant and non-compliant function type declarations:

```c
extern          f ( void );                 /* Non-compliant - implicit
                                             * int return type          */
extern int16_t  f ( void );                 /* Compliant                */

extern void g ( char c, const k );          /* Non-compliant - implicit
                                             * int for parameter k      */
extern void g ( char c, const int16_t k );  /* Compliant                */
```

The following examples show compliant and non-compliant type definitions:

```c
typedef ( *pfi ) ( void );                  /* Non-compliant - implicit int
                                             * return type              */
typedef int16_t ( *pfi ) ( void );          /* Compliant                */
typedef void ( *pfv ) ( const x );          /* Non-compliant - implicit int
                                             * for parameter x          */
typedef void ( *pfv ) ( int16_t x );        /* Compliant                */
```

The following examples show compliant and non-compliant member declarations:

```c
struct str
{
  int16_t x;  /* Compliant                               */
  const   y;  /* Non-compliant - implicit int for member y */
} s;
```

## See also
Rule 8.2

---

Copyright The MISRA Consortium Limited © [Date - March 2025].