# Rule 8.4 A compatible declaration shall be visible when an object or function with external linkage is defined

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
A compatible declaration is one which declares a compatible type for the object or function being defined.

## Rationale
If a declaration for an object or function is visible when that object or function is defined, a compiler must check that the declaration and definition are compatible. In the presence of function prototypes, as required by Rule 8.2, checking extends to the number and type of function parameters.

The recommended method of implementing declarations of objects and functions with external linkage is to declare them in a *header file*, and then include the *header file* in all those code files that need them, including the one that defines them (See Rule 8.5).

## Exception
The function *main* need not have a separate declaration.

## Example
In these examples there are no declarations or definitions of objects or functions other than those present in the code.

```c
extern  int16_t count;
        int16_t count = 0;        /* Compliant */

extern uint16_t speed = 6000u;    /* Non-compliant - no declaration
                                   * prior to this definition */

uint8_t pressure = 101u;          /* Non-compliant - no declaration
                                   * prior to this definition */

extern void func1 ( void );
extern void func2 ( int16_t x, int16_t y );
extern void func3 ( int16_t x, int16_t y );

void func1 ( void )
{
  /* Compliant */
}
```

The following non-compliant definition of `func3` also violates Rule 8.3.

```c
void func2 ( int16_t x, int16_t y )
{
  /* Compliant */
}

void func3 ( int16_t x, uint16_t y )
{
  /* Non-compliant - parameter types different */
}

void func4 ( void )
{
  /* Non-compliant - no declaration of func4 before this definition */
}

static void func5 ( void )
{
  /* Compliant - rule does not apply to objects/functions with internal
   * linkage */
}
```

## See also
Rule 8.2, Rule 8.3, Rule 8.5, Rule 17.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].